package gov.va.genisis2.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;


/**
 * The Class UserApprover.
 * 
 * Description: In this UserApprover Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Approver Table in
 * the database.
 * 
 */
@Entity
@Table(name = "User_Approver", schema = "dbo")
public class UserApprover implements java.io.Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = 4004763796568945048L;

	/** The id. */
	private int id;
	
	/** The users by user approver id. */
	private Users usersByUserApproverId;
	
	/** The users by user id. */
	private Users usersByUserId;

	/**
	 * Instantiates a new user approver.
	 */
	public UserApprover() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * Instantiates a new user approver.
	 *
	 * @param id the id
	 * @param usersByUserApproverId the users by user approver id
	 * @param usersByUserId the users by user id
	 */
	public UserApprover(int id, Users usersByUserApproverId, Users usersByUserId) {
		this.id = id;
		this.usersByUserApproverId = usersByUserApproverId;
		this.usersByUserId = usersByUserId;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the users by user approver id.
	 *
	 * @return the users by user approver id
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "User_Approver_id", nullable = false)
	public Users getUsersByUserApproverId() {
		return this.usersByUserApproverId;
	}

	/**
	 * Sets the users by user approver id.
	 *
	 * @param usersByUserApproverId the new users by user approver id
	 */
	public void setUsersByUserApproverId(Users usersByUserApproverId) {
		this.usersByUserApproverId = usersByUserApproverId;
	}

	/**
	 * Gets the users by user id.
	 *
	 * @return the users by user id
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "User_id", nullable = false)
	public Users getUsersByUserId() {
		return this.usersByUserId;
	}

	/**
	 * Sets the users by user id.
	 *
	 * @param usersByUserId the new users by user id
	 */
	public void setUsersByUserId(Users usersByUserId) {
		this.usersByUserId = usersByUserId;
	}

}
